
**************************************************************
* Figure 13. Predictions for Median CPI Inflation Gap During the Pandemic: Comparison Across Models
**************************************************************

**************************************************************
* Read in data
**************************************************************

set more off
clear
* Put name of your main directory path here:
local main = "___"
cd `main'
use data_monthly.dta, clear

**************************************************************
* Data work
**************************************************************

* Variables

local latest = tm(2022m9)

forval s = 1/4 {
	g sample`s' = 0
}
replace sample1 = 1 if (t>=tm(1960m1)) & (t<=tm(1972m12))
replace sample2 = 1 if (t>=tm(1973m1)) & (t<=tm(1984m12))
replace sample3 = 1 if (t>=tm(1985m1)) & (t<=tm(2019m12))
replace sample4 = 1 if (t>=tm(2020m1)) & (t<=`latest')

**************************************************************
* Variables
**************************************************************

* Inflation gap
cap drop y x*
g y		= Median-pe

* Relative price fluctuations (supply shocks)
g his			= CPI - Median
* 12-month average
gen his_12ma	= (1/12)*(his + his[_n-1] + his[_n-2] + his[_n-3] + his[_n-4] + his[_n-5] + his[_n-6] + his[_n-7] + his[_n-8] + his[_n-9] + his[_n-10] + his[_n-11])

* Measure of slack
foreach var in vu {
	* Define measure of slack ("x")
	cap drop x*
	g x		= `var'_12ma
	g x2	= x^2
	g x3	= x^3
	* Compute nonlinear "z" terms

}

	gen z	= his_12ma
	gen z2	=z^2
	gen z3	=z^3
		
**************************************************************
//* Estimation and chart: 1985-2019
**************************************************************

local index = 1
*local title = "A. Sample: 1985-2022"
local title = ""

preserve
newey y ugap_12ma    		if sample3==1,  lag(12)
predict yhat1
newey y x    				if sample3==1,  lag(12)
predict yhat2
newey y x x2 x3    			if sample3==1,  lag(12)
predict yhat3
newey y x x2 x3 z   		if sample3==1,  lag(12)
predict yhat4
newey y x x2 x3 z z2 z3   	if sample3==1,  lag(12)
predict yhat5

* Labels
label variable y "Actual"
label variable yhat1 "Linear in U"
label variable yhat2 "Linear in V/U"
label variable yhat3 "Nonlinear in V/U"
label variable yhat4 "Nonlinear in V/U, linear in H"
label variable yhat5 "Nonlinear in both V/U and H"

* Chart
keep if (t>=tm(2020m1) & t<=`latest')
sum t
local t0 = r(min)
local t1 = r(max)
twoway (line y yhat2 yhat3 yhat4 t, yline(0, lcolor(ebg)) lcolor(blue orange midblue midblue) lpattern(solid dash_dot longdash shortdash) lwidth(medthick medthick medthick medthick medthick medthick)) ///
(connect yhat1 t, lcolor(red) lwidth(medthick) msize(medium) msymbol(X) mcolor(red) lpattern(dash)) ///
(connect yhat5 t, lcolor(midblue) lwidth(medthick) msize(small) mcolor(midblue) lpattern(shortdash) ///
ylabel(-2(2)10) ///
xtitle("") xmtick(#31) xlabel(`t0'(12)`t1', format(%tmCY)) ///
legend(row(6) symxsize(8) ring(0) position(11) bmargin(none) region(style(none))) ///
legend(order(1 5 2 3 4 6)) ///
legend(size(medium)) ///
title("`title'") ///
saving(`index'.gph, replace))
rename y Actual
rename yhat1 linear_in_U
rename yhat2 linear_in_VU
rename yhat3 nonlinear_in_VU
rename yhat4 nonlinear_in_VU_linear_in_H
rename yhat5 nonlinear_in_both
outsheet Actual linear_in_U linear_in_VU nonlinear_in_VU nonlinear_in_VU_linear_in_H nonlinear_in_both t using "results\charts\Figure 13.xls", replace
restore



